TITLE hhaxon.mod   squid sodium, potassium, and leak channels
 
COMMENT
 This is the original Hodgkin-Huxley treatment for the set of sodium, 
  potassium, and leakage channels found in the squid giant axon membrane.
  ("A quantitative description of membrane current and its application 
  conduction and excitation in nerve" J.Physiol. (Lond.) 117:500-544 (1952).)
 Membrane voltage is in absolute mV and has been reversed in polarity
  from the original HH convention and shifted to reflect a resting potential
  of -65 mV.
 Remember to set celsius=6.3 (or whatever) in your HOC file.
 See squid.hoc for an example of a simulation using this model.
 SW Jaslove  6 March, 1992
ENDCOMMENT
 
UNITS {
        (mA) = (milliamp)
        (mV) = (millivolt)
	(S) = (siemens)
}
 
? interface
NEURON {
        SUFFIX hhaxon
        USEION na READ ena WRITE ina
        USEION k READ ek WRITE ik
        NONSPECIFIC_CURRENT il
        RANGE gnabar, gkbar, gl, el, gna, gk, q10m, q10n, q10h
        GLOBAL minf, hinf, ninf, mtau, htau, ntau
	THREADSAFE : assigned GLOBALs will be per thread
}
 
PARAMETER {
        gnabar = .48 (S/cm2)	<0,1e9>
        gkbar = 1.088 (S/cm2)	<0,1e9>
        gl = .0016 (S/cm2)	<0,1e9>
        el = -60.0 (mV)
	q10m = 1
	q10n = 1
	q10h = 1
	}
 
STATE {
        m h n
}
 
ASSIGNED {
        v (mV)
        celsius (degC)
        ena (mV)
        ek (mV)

	gna (S/cm2)
	gk (S/cm2)
        ina (mA/cm2)
        ik (mA/cm2)
        il (mA/cm2)
        minf hinf ninf
	mtau (ms) htau (ms) ntau (ms)
}
 
? currents
BREAKPOINT {
        SOLVE states METHOD cnexp
        gna = gnabar*m*m*m*h
	ina = gna*(v - ena)
        gk = gkbar*n*n*n*n
	ik = gk*(v - ek)      
        il = gl*(v - el)
}
 
 
INITIAL {
	rates(v)
	m = minf
	h = hinf
	n = ninf
}

? states
DERIVATIVE states {  
        rates(v)
        m' =  (minf-m)/mtau
        h' = (hinf-h)/htau
        n' = (ninf-n)/ntau
}
 
:LOCAL q10


? rates
PROCEDURE rates(v(mV)) {  :Computes rate and other constants at current v.
                      :Call once from HOC to initialize inf at resting v.
        LOCAL	q10 
        TABLE minf, mtau, hinf, htau, ninf, ntau DEPEND q10m, q10n, q10h FROM -100 TO 100 WITH 200

UNITSOFF

                :"m" sodium activation system
	minf = 1/(1+exp(-0.4*(36+v)))
	mtau = (1/q10m)*(2*exp(-0.05*(v+40)))
                :"h" sodium inactivation system
	htau = (1/q10h)*(40*exp(-0.025*(v+55)))
        hinf = 1/(1+exp(39.5+v))
                :"n" potassium activation system
        ninf = 1/(1+exp(0.125*(-33-v)))
        ntau = (1/q10n)*(55*exp(-0.015*(v+28)))
}
 

 
UNITSON
